/*
   ######################################################################

   XBlast Robot.inc

   Character design tutorial part 2

   (C) by Mark Weyer

   ######################################################################
*/

//
///
//// You may have noticed three things:
//// - The character colours were not adjustable in the appropriate
////   xblast menu.
//// - The character became greyish.
//// - The character was partly transparent.
//// All of those have the same reason.
//// We may not choose colours arbitrarily.
//// There are two kinds of colours for our character:
//// - adjustable colours (here: yellow, blue, green)
////   for the character's features (here: wheel colour 1, wheel colour 2,
////   eye colour).
////   There are all together six adjustable colours.
////   Their names in povray are faceColor, helmetColor, bodyColor,
////   backpackColor, armsLegsColor and handsFeetColor.
//// - fixed colours (here: white and black) for things that are not fit
////   to colour arbitrarily (here: the white of the eye and the pupils).
////   Those have to be shades of grey.
//// We will now make adjustments.
///
//

//
///
//// The adjustable colours have peculiar names. We will use local names.
///
//

// colours

#local wheelColour1 = handsFeetColor;
#local wheelColour2 = armsLegsColor;
#local eyeColour = faceColor;

// basic constants

#declare Wheel_diam = 2;
#declare Wheel_thickness = 1/2;
#declare Eye_size = 2/3;

// a macro for eyes

#macro eye(side)
  sphere {
    0 1/2
    pigment {	// this pigment partitions the eye into three layers:
		// black (pupil), eyeColour (iris), and white (rest)
      checker
      pigment {rgb <1,1,1>}
      pigment {
        checker
        pigment {rgb eyeColour}
        pigment {rgb <0,0,0>}
        translate <1/2,1/2,0>
        scale 10
        translate -z/4
      }
      translate <1/2,1/2,0>
      scale <10,10,1>
      translate -z/6
    }
//
///
//// Previously this pigment had been:
///
//
//    pigment {	// this pigment partitions the eye into three layers:
//		// black (pupil), green (iris), and white (rest)
//      checker
//      pigment {rgb <1,1,1>}
//      pigment {
//        checker
//        pigment {rgb <0,1,0>}
//        pigment {rgb <0,0,0>}
//        translate <1/2,1/2,0>
//        scale 10
//        translate -z/4
//      }
//      translate <1/2,1/2,0>
//      scale <10,10,1>
//      translate -z/6
//    }
//
    scale Eye_size
    translate <side*2/3,Wheel_diam,-1/2>
  }
#end

#macro wheel()
  torus {
    (Wheel_diam-Wheel_thickness)/2 Wheel_thickness/2
    rotate 90*z
    pigment {	// this pigment partitions the wheel in four sectors
      checker
      pigment {rgb wheelColour1}
      pigment {rgb wheelColour2}
      translate x/2
      scale 10
    }
//
///
//// Previously this pigment had been:
///
//
//    pigment {	// this pigment partitions the wheel in four sectors
//      checker
//      pigment {rgb <1,1,0>}
//      pigment {rgb <0,0,1>}
//      translate x/2
//      scale 10
//    }
//
    translate Wheel_diam/2*y
  }
#end

union {
  wheel()
  eye(1)
  eye(-1)

  rotate playerAngle*y
  translate playerLocation
  translate -2*z
}

